<?php


namespace Mainto\RpcServer\Util\ObjectMapper;


use ReflectionException;

/**
 * Class JsonMapper
 * @package Mainto\RpcServer\Util\ObjectMapper
 */
class JsonMapper implements MapperInterface {
    /**
     * @var array ['class_key' => ClassRef]
     */
    private static array $classRefMap = [];

    private static array $noConvType = [
        'bool',
        'int',
        'string',
        'float',
        'array',
    ];

    /**
     * @param $data
     * @param object $object
     */
    public function map ($data, object $object) {
        if (is_string($data)) {
            $data = json_decode($data, true);
        }

        $this->mapJsonArray($data, $object);
    }

    public function mapJsonArray (array $data, object $object) {
        $classRef = self::classRef($object);

        foreach ($classRef->publicPropertyRefs as $propertyRef) {
            if (!array_key_exists($propertyRef->property->getName(), $data)) {
                continue;
            }

            $type = $propertyRef->type;
            if (in_array($type, self::$noConvType)) {
                $propertyRef->property->setValue($object, $data[$propertyRef->property->getName()]);
            } else {
                if (ends_with($type, '[]')) {
                    $arrayValue = [];
                    $subType = substr($type, 0, -2);
                    foreach ($data[$propertyRef->property->getName()] as $datum) {
                        $subObject = new $subType;
                        $this->mapJsonArray($datum, $subObject);
                        $arrayValue[] = $subObject;
                    }

                    $propertyRef->property->setValue($object, $arrayValue);
                } else {
                    $propertyObject = new $type;
                    $this->mapJsonArray($data[$propertyRef->property->getName()], $propertyObject);
                    $propertyRef->property->setValue($object, $propertyObject);
                }
            }
        }
    }

    /**
     * @param object $object
     * @return ClassRef
     * @throws ReflectionException
     */
    protected static function classRef (object $object): ClassRef {
        $propertiesKey = get_class($object).'_properties';
        if (isset(self::$classRefMap[$propertiesKey])) {
            return self::$classRefMap[$propertiesKey];
        } else {
            return self::$classRefMap[$propertiesKey] = new ClassRef($object);
        }
    }
}