<?php

if (!function_exists('path_join')) {
    function path_join(...$args) {
        $path = "";
        foreach ($args as $arg) {
            if (!$arg) continue;

            $path .= $path ? (DIRECTORY_SEPARATOR . trim($arg, DIRECTORY_SEPARATOR)) : rtrim($arg, DIRECTORY_SEPARATOR);
        }

        return $path;
    }
}

if (!function_exists('remove_all')) {
    function remove_all($dir) {
        $files = array_diff(scandir($dir), array('.','..'));
        foreach ($files as $file) {
            (is_dir("$dir/$file")) ? remove_all("$dir/$file") : unlink("$dir/$file");
        }
        return rmdir($dir);
    }
}

if (!function_exists('get_object_public_vars')) {
    function get_object_public_vars($object) {
        return get_object_vars($object);
    }
}

if (!function_exists('get_files')) {
    /**
     * Get files
     * @param $dir
     * @return array
     */
    function get_files ($dir) {
        $files = [];
        $scan = scandir($dir);
        foreach ($scan as $item) {
            if ($item == '.' || $item == '..') continue;
            if (is_dir($dir.'/'.$item)) {
                $files = array_merge($files, get_files($dir.'/'.$item));
            } else {
                $files[] = $dir.'/'.$item;
            }
        }
        return $files;
    }
}