<?php

if (!function_exists('rpc_gateway_url')) {
    /**
     * @param $environment
     * @return bool|mixed|string
     */
    function rpc_gateway_url($environment) {
        switch ($environment) {
            case 'stable':
                return 'https://api-gateway.hzmantu.com';
            case 'dev':
                return 'https://api.dev.hzmantu.com';
            case 'pre':
                return 'https://api.pre.hzmantu.com';
            case 'release':
                return 'https://api.release.hzmantu.com';
            case 'release-deploy':
                if (env('RPC_GATEWAY_URL')) {
                    return env('RPC_GATEWAY_URL');
                }
        }

        return 'http://localhost:3080';
    }
}

if (!function_exists('rpc_environment')) {
    /**
     * @param $hostname
     * @return bool|mixed|string
     */
    function rpc_environment($hostname) {
        $hostnameArr = explode('-', $hostname);
        if (count($hostnameArr) >= 3) {
            $tag = $hostnameArr[count($hostnameArr) - 3];
            switch ($tag) {
                case 'stable':
                    return 'stable';
                case 'pre':
                    return 'pre';
                case 'dev':
                    return 'dev';
                case 'release':
                    if (env('RPC_GATEWAY_URL')) {
                        return 'release-deploy';
                    }
                    return 'release';
            }
        }

        return 'local';
    }
}

if (!function_exists('path_join')) {
    function path_join(...$args) {
        $path = "";
        foreach ($args as $arg) {
            if (!$arg) continue;

            $path .= $path ? (DIRECTORY_SEPARATOR . trim($arg, DIRECTORY_SEPARATOR)) : rtrim($arg, DIRECTORY_SEPARATOR);
        }

        return $path;
    }
}

if (!function_exists('remove_all')) {
    function remove_all($dir) {
        $files = array_diff(scandir($dir), array('.','..'));
        foreach ($files as $file) {
            (is_dir("$dir/$file")) ? remove_all("$dir/$file") : unlink("$dir/$file");
        }
        return rmdir($dir);
    }
}

if (!function_exists('rpc_exception_trace')) {
    function rpc_exception_trace(Throwable $throwable): string {
        $traceStr = "\n";
        foreach (explode("\n", $throwable->getTraceAsString()) as $key => $value) {
            $traceStr .= $value."\n";
            if (strpos($value, 'php-rpc-framework/src/RpcServer/RpcInvoke.php') !== false
                && strpos($value, 'ReflectionMethod->invokeArgs()') !== false) {
                $traceStr .= "[framework trace]";
                break;
            }
        }

        return $traceStr;
    }
}