<?php

if (!function_exists('path_join')) {
    function path_join(...$args) {
        $path = "";
        foreach ($args as $arg) {
            if (!$arg) continue;

            $path .= $path ? (DIRECTORY_SEPARATOR . trim($arg, DIRECTORY_SEPARATOR)) : rtrim($arg, DIRECTORY_SEPARATOR);
        }

        return $path;
    }
}

if (!function_exists('remove_all')) {
    function remove_all($dir) {
        $files = array_diff(scandir($dir), array('.','..'));
        foreach ($files as $file) {
            (is_dir("$dir/$file")) ? remove_all("$dir/$file") : unlink("$dir/$file");
        }
        return rmdir($dir);
    }
}

if (!function_exists('rpc_exception_trace')) {
    function rpc_exception_trace(Throwable $throwable): string {
        $traceStr = "\n";
        foreach (explode("\n", $throwable->getTraceAsString()) as $key => $value) {
            $traceStr .= $value."\n";
            if (strpos($value, 'php-rpc-framework/src/RpcServer/RpcInvoke.php') !== false
                && strpos($value, 'ReflectionMethod->invokeArgs()') !== false) {
                $traceStr .= "[framework trace]";
                break;
            }
        }

        return $traceStr;
    }
}