<?php


namespace Mainto\RpcServer\Command;


use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Mainto\RpcServer\Log\LogHandler;
use Mainto\RpcServer\RpcServer\Connection\RpcUnixConnection;
use Mainto\RpcServer\RpcServer\ConnectionHandler\ChildConnectionHandler;

class RpcChildCommand extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:child {--unix=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Worker Command';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    public function handle() {
        $unix = $this->option('unix');

        LogHandler::init(storage_path("logs/service/".now()->format("Y-m-d")), 'child');

        Log::info("master start and serve", ['pid' => getmypid(), 'unix' => $unix]);

        RpcUnixConnection::mustNewInstance($unix, new ChildConnectionHandler(), 3)->start();
    }
}