<?php


namespace Mainto\RpcServer\Protocol\Common;


use Mainto\RpcServer\Protocol\Common\Types\RequestHeaderType;
use Mainto\RpcServer\Protocol\Common\Types\ResponseHeaderType;

class BaseType {
    const StreamSize = 3;
    const EmptySize = 3;
    const MainTypeSize = 6;
    const SecondTypeSize = 4;
    const Mask = 0xFFFF;
    const StreamMask = self::Mask & 0xE000;
    const MainTypeMask = self::Mask & 0x03F0;
    const SecondTypeMask = self::Mask & 0x000F;
    const TypeMask = self::MainTypeMask | self::SecondTypeMask;

    const StreamOpen = (1 << (BaseType::EmptySize + BaseType::MainTypeSize + BaseType::SecondTypeSize)) & BaseType::StreamMask;
    const StreamChunk = (2 << (BaseType::EmptySize + BaseType::MainTypeSize + BaseType::SecondTypeSize)) & BaseType::StreamMask;
    const StreamClose = (3 << (BaseType::EmptySize + BaseType::MainTypeSize + BaseType::SecondTypeSize)) & BaseType::StreamMask;
    const StreamErrorClose = (4 << (BaseType::EmptySize + BaseType::MainTypeSize + BaseType::SecondTypeSize)) & BaseType::StreamMask;

    const Map = [
        self::StreamOpen       => 'streamOpen',
        self::StreamChunk      => 'StreamChunk',
        self::StreamClose      => 'StreamClose',
        self::StreamErrorClose => 'StreamErrorClose',

        RequestHeaderType::UrlInvokeGetType        => 'UrlInvokeGetType',
        RequestHeaderType::UrlInvokePostType       => 'UrlInvokePostType',
        RequestHeaderType::UrlInvokePutType        => 'UrlInvokePutType',
        RequestHeaderType::UrlInvokeDeleteType     => 'UrlInvokeDeleteType',
        RequestHeaderType::UrlInvokePatchType      => 'UrlInvokePatchType',
        RequestHeaderType::InvokeNormalType        => 'InvokeNormalType',
        RequestHeaderType::MessageNormalType       => 'MessageNormalType',
        RequestHeaderType::MessageDelayType        => 'MessageDelayType',
        RequestHeaderType::MessageRetryType        => 'MessageRetryType',
        RequestHeaderType::CronNormalType          => 'CronNormalType',
        RequestHeaderType::WebsocketNormalType     => 'WebsocketNormalType',
        RequestHeaderType::WebsocketConnectType    => 'WebsocketConnectType',
        RequestHeaderType::WebsocketDisconnectType => 'WebsocketDisconnectType',
        RequestHeaderType::SystemCheckType         => 'SystemCheckType',

        RequestHeaderType::SidecarScaleUpType => 'ServiceScaleType',
        RequestHeaderType::SidecarConfigType  => 'ServiceConfigType',
        RequestHeaderType::SidecarStopType    => 'SidecarStopType',
        RequestHeaderType::SidecarSettingType => 'SidecarSettingType',
        RequestHeaderType::SidecarSLSType     => 'SidecarSLSType',
        RequestHeaderType::SidecarMonitorType     => 'SidecarMonitorType',

        ResponseHeaderType::ReturnOKType         => 'ReturnOKType',
        ResponseHeaderType::ReturnAuthInvokeType => 'ReturnAuthInvokeType',
        ResponseHeaderType::ReturnAuthRevokeType => 'ReturnAuthRevokeType',
        ResponseHeaderType::ReturnErrType        => 'ReturnErrType',
        ResponseHeaderType::ReturnSystemErrType  => 'ReturnSystemErrType',
    ];
}