<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 8/8/18
 * Time: 6:10 PM
 */

namespace Mainto\RpcServer\RpcUtil\Tool;

use Mainto\RpcServer\RpcUtil\Tool\MonitorDriver\MonitorDriveAbstract;
use Mainto\RpcServer\RpcUtil\Tool\MonitorDriver\SidecarPrometheus;
use RuntimeException;

class RpcMonitor {
    protected static ?MonitorDriveAbstract $instance = null;
    protected static array $driverMap = [
        'prometheus'   => SidecarPrometheus::class,
    ];

    /**
     * get the log instance
     *
     * @return MonitorDriveAbstract
     */
    public static function getInstance () {
        if (!static::$instance) {
            $logDriver = config("rpc-server.monitor_driver");
            if (!isset(static::$driverMap[$logDriver])) {
                throw new RuntimeException("can not find {$logDriver} monitor driver");
            }

            static::$instance = new static::$driverMap[$logDriver]();
        }
        return static::$instance;
    }

    /**
     * clear cache instance
     */
    public static function clearInstance () {
        static::$instance = null;
    }
}