<?php

namespace Mainto\RpcServer\RpcUtil\Tool\MonitorDriver;

use Illuminate\Support\Str;
use Mainto\RpcServer\RpcUtil\Tool\RpcLogInterface;
use Mainto\RpcServer\Protocol\Request\Request;
use Mainto\RpcServer\RpcUtil\Tool\RpcMonitorInterface;
use Throwable;

abstract class MonitorDriveAbstract implements RpcMonitorInterface {
    protected bool $localMode = true;

    /**
     * LogDriveAbstract constructor.
     */
    public function __construct () {
        $this->localMode = config('app.env', "local") === "local";
    }

    /**
     * get trace info
     * @param int $offset
     * @return array
     */
    protected function getTraceInfo ($offset = 0) {
        $trace = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 4);
        $file = $trace[2 + $offset]['file'] ?? "";
        $line = $trace[2 + $offset]['line'] ?? "unknown";
        $class = $trace[3 + $offset]['class'] ?? "";
        $type = $trace[3 + $offset]['type'] ?? "::";
        $function = $trace[3 + $offset]['function'] ?? "";

        if (Str::endsWith($function, "{closure}")) {
            $function = "{closure}";
        }

        return [
            "source" => "{$class}{$type}{$function} ($line)",
            "file"   => "{$file} ($line)",
        ];
    }


    /**
     * transform object to pretty json string
     *
     * @param $obj
     * @return string
     */
    protected function transObject ($obj) {
        return json_encode($obj, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    }

    /**
     * throwable error log
     *
     * @param $request
     * @param $source
     * @param Throwable $e
     */
    abstract public function requestThrowable (Request $request, Throwable $e, string $source = "");

    abstract public function throwable ($request, Throwable $e, string $source = "");

}