<?php


namespace Mainto\RpcServer\RpcServer\ContextTrait;


use Mainto\RpcServer\Protocol\Common\Types\BodyType;
use Mainto\RpcServer\Protocol\Request\Request;

trait RequestTrait {
    /**
     * @var Request
     */
    private Request $request;

    /**
     * @return Request
     */
    public function getRequest (): Request {
        return $this->request;
    }

    public function isRawMode() {
        return optional($this->request->getBody())->getBodyType() == BodyType::RAW;
    }
}