<?php


namespace Mainto\RpcServer\RpcServer;


use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Support\Arr;
use stdClass;

/**
 * Class RpcParams
 * @package Mainto\RpcServer\Server
 */
class RpcParams implements Arrayable {
    public array $_declareNames = [];

    private array $params;

    /**
     * 获得声明中的参数
     */
    public function onlyDeclare (): array {
        $res = [];

        $placeholder = new stdClass;
        foreach ($this->_declareNames as $name) {
            $get = data_get($this->params, $name, $placeholder);
            if ($get !== $placeholder) {
                Arr::set($res, $name, $get);
            }
        }

        return $res;
    }

    public function __construct ($params = []) {
        $this->params = $params;
    }

    public function only ($params = []): array {
        return array_only($this->params, $params);
    }

    public function get ($key, $default = null) {
        return array_get($this->params, $key, $default);
    }

    public function set ($key, $value) {
        return array_set($this->params, $key, $value);
    }

    public function except ($keys): array {
        return array_except($this->params, $keys);
    }

    public function has ($key): bool {
        return array_has($this->params, $key);
    }

    public function toArray(): array {
        return $this->params;
    }
}