<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 18-12-23
 * Time: 下午4:43
 */

namespace Mainto\RpcServer\Command;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Mainto\RpcServer\RpcClient\RpcClient;
use Mainto\RpcServer\RpcServer\Connection\RpcUnixConnection;
use Mainto\RpcServer\RpcServer\ConnectionHandler\MasterConnectionHandler;

class RpcServerCommand extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:server {--unix=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Cluster Command';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @throws \Throwable
     */
    public function handle () {
        $unix = $this->option('unix');

        Log::info(sprintf("[%d] master server start and serve on [%s]", getmypid(), $unix));

        RpcUnixConnection::mustNewInstance($unix, MasterConnectionHandler::newInstance(), 3)->start();
    }
}
