<?php


namespace Mainto\MRPC\Tool\Reader;



use Mainto\MRPC\Tool\IO\Reader;

class LimitReader implements Reader {
    /**
     * @var Reader
     */
    private Reader $reader;
    private int $size; // 剩余可读

    public function __construct (Reader $reader, int $size) {
        $this->reader = $reader;
        $this->size = $size;
    }

    public function read (int $size): ?string {
        if ($size > $this->size) {
            $size = $this->size;
        }

        if ($size === 0) {
            return null;
        }

        $read = $this->reader->read($size);
        if ($read === null) {
            return null;
        }

        $this->size -= strlen($read);

        return $read;
    }
}