<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/4/7
 * Time: 下午3:14
 */

namespace Mainto\MRPC\Protocol\Request\ContextTrait;


use Illuminate\Support\Arr;
use Illuminate\Support\Collection;
use Mainto\MRPC\ProtocolInvoke;
use stdClass;

trait ParamTrait {
    /**
     * 请求参数
     * @var Collection
     */
    private Collection $requestParams;

    /**
     * @var RpcInvoke
     */
    private RpcInvoke $requestInvoke;

    /**
     * 获得声明中的参数
     */
    public function onlyDeclare () {
        return $this->only($this->requestInvoke->getParamMap()->getDeclareName());
    }

    /**
     * 获得指定key部分的子集
     *
     * @param array|mixed $keys
     * @return array
     */
    public function only ($keys) {
        $results = [];

        $input = $this->all();

        $placeholder = new stdClass;

        foreach (is_array($keys) ? $keys : func_get_args() as $key) {
            $value = data_get($input, $key, $placeholder);

            if ($value !== $placeholder) {
                Arr::set($results, $key, $value);
            }
        }

        return $results;
    }

    /**
     * 从请求中获取全部信息
     *
     * @param array|mixed $keys
     * @return array
     */
    public function all ($keys = null) {
        $input = $this->input();

        if (!$keys) {
            return $input;
        }

        $results = [];

        foreach (is_array($keys) ? $keys : func_get_args() as $key) {
            Arr::set($results, $key, Arr::get($input, $key));
        }

        return $results;
    }

    /**
     * 获取参数输入
     *
     * @param null $key
     * @param null $default
     * @return mixed
     */
    public function input ($key = null, $default = null) {
        return data_get($this->requestParams->all(), $key, $default);
    }

    /**
     * 得到除了指定key之外的子集
     *
     * @param array|mixed $keys
     * @return array
     */
    public function except ($keys) {
        $keys = is_array($keys) ? $keys : func_get_args();

        $results = $this->all();

        Arr::forget($results, $keys);

        return $results;
    }

    /**
     * 设置输入的参数
     *
     * @param $key
     * @param $value
     */
    public function setInput ($key, $value) {
        $this->requestParams[$key] = $value;
    }

    /**
     * 判断请求中是否存在
     *
     * @param $key
     * @return bool
     */
    public function has ($key) {
        return $this->requestParams->has($key);
    }

}