<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 18-10-22
 * Time: 下午3:17
 */

namespace Mainto\RpcServer\Providers;

use Mainto\RpcServer\RpcUtil\Tool\RpcMutexProviderInterface;
use Mainto\RpcServer\RpcServer\RpcSessionHandlerInterface;

/**
 * Class RpcServerServiceProvider
 * @package Mainto\RpcServer\Providers
 * @deprecated please use ServiceProvider and \Mainto\MRPCTool\Providers\RpcToolServiceProvider
 */
class RpcServerServiceProvider extends ServiceProvider {
    /**
     * @var \Mainto\MRPCTool\Providers\RpcToolServiceProvider
     */
    private $toolProvider;

    public function __construct ($app) {
        parent::__construct($app);
        putenv("RPC_TOOL_CMD_NAMESPACE_CONTROLLER_DOC=Mainto\RpcServer\TestHelper\ControllerDoc");

        if (class_exists("\Mainto\MRPCTool\Providers\RpcToolServiceProvider")) {
            $this->toolProvider = new \Mainto\MRPCTool\Providers\RpcToolServiceProvider($app);
        }
    }

    public function boot () {
        parent::boot();
        if ($this->toolProvider) {
            $this->toolProvider->boot();
        }
    }

    public function register () {
        parent::register();
        if ($this->toolProvider) {
            $this->toolProvider->register();
        }
        if (class_exists("\Mainto\Bridge\Invokes\CoreGear\Lock")) {
            $this->app->singleton(RpcMutexProviderInterface::class, function () {
                return new class implements RpcMutexProviderInterface {
                    public static function getLock (string $lockName, int $expireTime = 86400) {
                        return \Mainto\Bridge\Invokes\CoreGear\Lock::getLock($lockName, $expireTime);
                    }

                    public static function unLock (string $lockName, string $password): bool {
                        return \Mainto\Bridge\Invokes\CoreGear\Lock::unlock($lockName, $password);
                    }
                };
            });
        }

        if (class_exists("\Mainto\Bridge\Invokes\CoreGear\Store")) {
            $this->app->singleton(RpcSessionHandlerInterface::class, function () {
                return new class implements RpcSessionHandlerInterface {
                    public function getSessionStringBySessionId ($sessionId): ?string {
                        return \Mainto\Bridge\Invokes\CoreGear\Store::get($sessionId);
                    }

                    public function updateSession ($sessionId, $sessionString, $seconds): void {
                        \Mainto\Bridge\Invokes\CoreGear\Store::set($sessionId, $sessionString, $seconds);
                    }

                    public function deleteSession ($sessionId): void {
                        \Mainto\Bridge\Invokes\CoreGear\Store::delete($sessionId);
                    }
                };
            });
        }
    }
}
