<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 18-10-22
 * Time: 下午3:17
 */

namespace Mainto\RpcServer\Providers;

use Mainto\Bridge\Invokes\CoreGear\Lock;
use Mainto\Bridge\Invokes\CoreGear\Store;
use Mainto\RpcServer\RpcUtil\Tool\RpcMutexProviderInterface;
use Mainto\RpcServer\RpcServer\RpcSessionHandlerInterface;

/**
 * Class RpcServerServiceProvider
 * @package Mainto\RpcServer\Providers
 * @deprecated please use ServiceProvider and RpcToolServiceProvider
 */
class RpcServerServiceProvider extends ServiceProvider {
    /**
     * @var RpcToolServiceProvider
     */
    private RpcToolServiceProvider $toolProvider;

    public function __construct ($app) {
        parent::__construct($app);
        putenv("RPC_TOOL_CMD_NAMESPACE_CONTROLLER_DOC=Mainto\RpcServer\TestHelper\ControllerDoc");

        $this->toolProvider = new RpcToolServiceProvider($app);
    }

    public function boot () {
        parent::boot();
        $this->toolProvider->boot();
    }

    public function register () {
        parent::register();
        $this->toolProvider->register();

        $this->app->singleton(RpcMutexProviderInterface::class, function () {
            return new class implements RpcMutexProviderInterface {
                public static function getLock (string $lockName, int $expireTime = 86400) {
                    return Lock::getLock($lockName, $expireTime);
                }

                public static function unLock (string $lockName, string $password): bool {
                    return Lock::unlock($lockName, $password);
                }
            };
        });

        $this->app->singleton(RpcSessionHandlerInterface::class, function () {
            return new class implements RpcSessionHandlerInterface {
                public function getSessionStringBySessionId ($sessionId): ?string {
                    return Store::get($sessionId);
                }

                public function updateSession ($sessionId, $sessionString, $seconds): void {
                    Store::set($sessionId, $sessionString, $seconds);
                }

                public function deleteSession ($sessionId): void {
                    Store::delete($sessionId);
                }
            };
        });
    }
}
