<?php

namespace Mainto\RpcServer\Server;

use Mainto\RpcServer\Protocol\Request\Extend\RequestExtendHeader;
use Mainto\RpcServer\Protocol\Request\Request;
use Mainto\RpcServer\Server\ContextTrait\HeaderTrait;
use Mainto\RpcServer\Server\ContextTrait\ParamTrait;
use Mainto\RpcServer\Server\ContextTrait\RequestTrait;
use Mainto\RpcServer\Server\ContextTrait\RpcMessageTrait;
use Mainto\RpcServer\Server\ContextTrait\SessionTrait;

class RpcContext {
    use ParamTrait;
    use HeaderTrait;
    use SessionTrait;
    use RpcMessageTrait;
    use RequestTrait;

    public static string $currentTraceId = "";

    /**
     * @param Request $request
     * @param RpcParams $params
     */
    public function __construct (Request $request, RpcParams $params) {
        $this->rpcParams = $params;
        $this->request = $request;

        if ($request->hasExt()) {
            $ext = $request->getExt();
            if ($ext instanceof RequestExtendHeader) {
                foreach ($ext->getAllHeader() as $key => $value) {
                    $this->requestHeaders[$key] = count($value) === 1 ? $value[0] : $value;
                }
            }
        }

        self::$currentTraceId = $this->request->getTraceId();
        $this->session_id = $this->getSessionId();
    }
}