<?php


namespace Mainto\RpcServer\Server\ConnectionHandler;


use Mainto\RpcServer\Protocol\Common\Types\RequestHeaderType;
use Mainto\RpcServer\Protocol\Request\Request;
use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\Server\RpcInvoke;
use Mainto\RpcServer\Server\BaseConnectionHandler;
use Mainto\RpcServer\Util\Net\Conn;

class ChildConnectionHandler extends BaseConnectionHandler {
    public function onRequest (Request $request): Response {
        switch ($request->getType()) {
            case RequestHeaderType::SystemCheckType:
                $this->cacheResponse->useReturnOKType();
                return $this->cacheResponse;
            case RequestHeaderType::InvokeNormalType:
            case RequestHeaderType::UrlInvokeDeleteType:
            case RequestHeaderType::UrlInvokePatchType:
            case RequestHeaderType::UrlInvokePostType:
            case RequestHeaderType::UrlInvokePutType:
            case RequestHeaderType::UrlInvokeGetType:

            case RequestHeaderType::MessageNormalType:
            case RequestHeaderType::MessageDelayType:
            case RequestHeaderType::MessageRetryType:

            case RequestHeaderType::CronNormalType:

            case RequestHeaderType::WebsocketNormalType:
            case RequestHeaderType::WebsocketConnectType:
            case RequestHeaderType::WebsocketDisconnectType:
                return RpcInvoke::invoke($request);
        }

        $this->cacheResponse->useReturnErrType();
        return $this->cacheResponse;
    }

    public function onClose (Conn $socket) {
    }

    public function beforeStart (Conn $conn) {
    }
}