<?php


namespace Mainto\RpcServer\Server\Connection;


use Mainto\RpcServer\Server\BaseRpcConnection;
use Mainto\RpcServer\Server\ConnectionHandler;
use Mainto\RpcServer\Util\Net\Net;

class RpcUnixConnection extends BaseRpcConnection {
    /**
     * RpcUnixConnection constructor.
     * @param $address
     * @param ConnectionHandler $handler
     */
    private function __construct ($address, ConnectionHandler $handler) {
        parent::__construct(Net::dial("unix", $address), $address, $handler);
    }

    public static function newInstance ($address, ConnectionHandler $handler) {
        return new self($address, $handler);
    }
}