<?php


namespace Mainto\RpcServer\Server\Connection;


use Mainto\RpcServer\Server\BaseRpcConnection;
use Mainto\RpcServer\Server\ConnectionHandler;
use Mainto\RpcServer\Util\Net\Net;

class RpcTcpConnection extends BaseRpcConnection {
    /**
     * RpcTcpConnection constructor.
     * @param string $address
     * @param $streamId
     * @param ConnectionHandler $handler
     */
    private function __construct (string $address, $streamId,  ConnectionHandler $handler) {
        parent::__construct(Net::dial("tcp", $address), $streamId, $handler);
    }

    public static function newInstance(string $address, $streamId,  ConnectionHandler $handler) {
        return new self($address, $streamId, $handler);
    }
}