<?php


namespace Mainto\RpcServer\Log;


interface RpcLogInterface {
    /**
     * log info message
     *
     * @param $title
     * @param $message
     */
    public function info (string $title, $message);

    /**
     * log debug message
     *
     * @param $title
     * @param $message
     */
    public function debug (string $title, $message);

    /**
     * log notice message
     *
     * @param $title
     * @param $message
     */
    public function notice (string $title, $message);

    /**
     * log warning message
     *
     * @param $title
     * @param $message
     */
    public function warning (string $title, $message);

    /**
     * log error message
     *
     * @param $source
     * @param $title
     * @param $message
     */
    public function error (string $title, $message);

    /**
     * log critical message
     *
     * @param $title
     * @param $message
     */
    public function critical (string $title, $message);
}