<?php


namespace Mainto\MRPC\Client;


use Mainto\MRPC\Util\Net\Net;

class RpcUnixClient extends BaseRpcClient {
    public static function getServiceClient(string $serviceName) {
        return new BaseRpcClient(Net::dial('unix', path_join(self::$baseUnixDir, 'rpc_services', "$serviceName.sock")));
    }

    public static function getMessageQueueClient() {
        return new BaseRpcClient(Net::dial("unix", path_join(self::$baseUnixDir, 'mq.sock')));
    }

    public static function getSettingClient() {
        return new BaseRpcClient(Net::dial("unix", path_join(self::$baseUnixDir, 'setting.sock')));
    }

    public static function getSLSClient() {
        return new BaseRpcClient(Net::dial("unix", path_join(self::$baseUnixDir, 'sls.sock')));
    }
}
