<?php


namespace Mainto\MRPC\Server\ConnectionHandler;


use Mainto\MRPC\Protocol\Common\Types\RequestHeaderType;
use Mainto\MRPC\Protocol\Request\Request;
use Mainto\MRPC\Protocol\Response\Response;
use Mainto\MRPC\Server\RpcInvoke;
use Mainto\MRPC\Server\BaseConnectionHandler;
use Mainto\MRPC\Util\Net\Conn;

class ChildConnectionHandler extends BaseConnectionHandler {
    public function onRequest (Request $request): Response {
        switch ($request->getType()) {
            case RequestHeaderType::SystemCheckType:
                $this->cacheResponse->useReturnOKType();
                return $this->cacheResponse;
            case RequestHeaderType::InvokeNormalType:
            case RequestHeaderType::UrlInvokeDeleteType:
            case RequestHeaderType::UrlInvokePatchType:
            case RequestHeaderType::UrlInvokePostType:
            case RequestHeaderType::UrlInvokePutType:
            case RequestHeaderType::UrlInvokeGetType:

            case RequestHeaderType::MessageNormalType:
            case RequestHeaderType::MessageDelayType:
            case RequestHeaderType::MessageRetryType:

            case RequestHeaderType::CronNormalType:

            case RequestHeaderType::WebsocketNormalType:
            case RequestHeaderType::WebsocketConnectType:
            case RequestHeaderType::WebsocketDisconnectType:
                return RpcInvoke::invoke($request);
        }

        $this->cacheResponse->useReturnErrType();
        return $this->cacheResponse;
    }

    public function onClose (Conn $socket) {
    }

    public function beforeStart (Conn $conn) {
    }
}