<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 8/8/18
 * Time: 6:10 PM
 */

namespace Mainto\MRPC\Log;

use Mainto\MRPC\Log\LogDriver\Local;
use Mainto\MRPC\Log\LogDriver\LogDriveAbstract;
use Mainto\MRPC\Log\LogDriver\SidecarSLS;
use RuntimeException;

class RpcLog {
    protected static ?LogDriveAbstract $instance = null;
    protected static array $driverMap = [
        'local' => Local::class,
        'sls'   => SidecarSLS::class,
    ];

    /**
     * get the log instance
     *
     * @return LogDriveAbstract
     */
    public static function getInstance () {
        if (!static::$instance) {
            $logDriver = config("rpc-server.log_driver");
            if (!isset(static::$driverMap[$logDriver])) {
                throw new RuntimeException("can not find {$logDriver} log driver");
            }

            // force local log
            if (!config('rpc-server.log_config.enable')) {
                $logDriver = 'local';
            }

            static::$instance = new static::$driverMap[$logDriver]();
        }
        return static::$instance;
    }

    /**
     * clear cache instance
     */
    public static function clearInstance () {
        static::$instance = null;
    }
}