<?php


namespace Mainto\MRPC\Client;


use Illuminate\Support\Facades\Log;
use Mainto\MRPC\Protocol\Request\Request;
use Mainto\MRPC\Protocol\Response\Response;
use Mainto\MRPC\Protocol\Response\ResponseReader;
use Mainto\MRPC\Util\IO\Closer;
use Mainto\MRPC\Util\Net\Conn;

class BaseRpcClient implements Closer {
    public static string $baseUnixDir;

    protected Conn $conn;

    private bool $verboseMode;
    private int $pid;

    public function __construct (Conn $conn) {
        $this->verboseMode = config('rpc-server.verbose_mode');
        $this->pid = getmypid();

        $this->conn = $conn;
    }

    public function Do (Request $request): Response {
        if ($this->verboseMode) {
            Log::debug("[client send req: {$this->pid}] \n".$request->dump());
        }
        $request->writeTo($this->conn);

        $responseReader = ResponseReader::ReadResponseFrom($this->conn);

        $response = $responseReader->toResponse();

        if ($this->verboseMode) {
            Log::debug("[client recv res: {$this->pid}] \n".$response->dump());
        }

        return $response;
    }

    public function close () {
        $this->conn->close();
    }

    public static function setBaseUnixDir($dir) {
        self::$baseUnixDir = $dir;
    }
}