<?php


namespace Mainto\MRPC\Server;


use Mainto\MRPC\Protocol\Common\Body;
use Mainto\MRPC\Protocol\Common\Types\RequestHeaderType;
use Mainto\MRPC\Protocol\Request\Request;
use Mainto\MRPC\Protocol\Request\RequestReader;
use Mainto\MRPC\Protocol\Response\Response;
use Mainto\MRPC\Protocol\RpcConnection;
use Mainto\MRPC\Service\RpcRouter;
use Mainto\MRPC\Tool\Socket;
use RuntimeException;

class Master extends RpcConnection {

    private static ?Master $instance = null;

    /**
     * @param string $server
     * @param string $port
     */
    protected function __construct (string $server, string $port) {
        parent::__construct($server, $port);
    }

    public static function newInstance(string $server, string $port): Master {
        if (self::$instance == null) {
            self::$instance = new self($server, $port);
        }

        return self::$instance;
    }

    public function onRequest (RequestReader $request): ?Response {
        switch ($request->getType()) {
            case RequestHeaderType::ServiceScaleType :
                $childId = pcntl_fork();
                if ($childId < 0) {
                    throw new RuntimeException("fork fail");
                } elseif ($childId == 0) {
                    (new Child($this->server, $this->port))->start();
                }
                break;
            case RequestHeaderType::ServiceConfigType:
                return self::serviceConfigResponse();

        }

        return null;
    }

    public function onClose (Socket $socket) {
    }

    public static function serviceConfigResponse() {
        $response = new Response();
        $response->useReturnOKType();

        $body = Body::newJsonBody(json_encode(RpcRouter::getInstance()->getBaseRouterConfig()));
        $response->setBody($body);

        return $response;
    }

    public static function initRequest (): Request {
        $request = new Request();
        $request->useServiceMasterConnType();

        return $request;
    }
}