<?php


namespace Mainto\MRPC\Protocol;


use Exception;
use Illuminate\Support\Facades\Log;
use Mainto\MRPC\Protocol\Request\Request;
use Mainto\MRPC\Protocol\Request\RequestReader;
use Mainto\MRPC\Protocol\Response\Response;
use Mainto\MRPC\Tool\Socket;

abstract class RpcConnection {
    /**
     * @var string
     */
    protected string $server;

    /**
     * @var string
     */
    protected string $port;

    /**
     * 啰嗦模式
     * @var bool
     */
    public static $verboseMode = false;

    /**
     * RpcServer constructor.
     * @param string $server
     * @param string $port
     */
    protected function __construct (string $server, string $port) {
        self::$verboseMode = env('RPC_VERBOSE_MODE', null);

        if (self::$verboseMode === null) {
            self::$verboseMode = env('APP_DEBUG', false);
        }

        $this->server = $server;
        $this->port = $port;
    }

    /**
     * RpcServer destruct
     */
    public function __destruct () {
        Log::error("server exit...");
    }

    abstract public function onRequest(RequestReader $request): ?Response;

    abstract public function onClose(Socket $socket);

    public function start() {
        $socket = new Socket($this->server, $this->port);
        $socket->send(static::initRequest()->encode());

        while (true) {
            try {
                $request = RequestReader::ReadRequestFrom($socket);

                $response = $this->onRequest($request);
                if ($response !== null) {
                    $socket->send($response->encode());
                }
            } catch (Exception $exception) {
                Log::error($exception);
                break;
            }
        }

        $this->onClose($socket);

        $socket->close();
    }

    abstract public static function initRequest(): Request;
}