<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/3/18
 * Time: 上午11:50
 */

namespace Mainto\MRPC\Protocol\Request;


use Mainto\MRPC\Protocol\Request\ContextTrait\HeaderTrait;
use Mainto\MRPC\Protocol\Request\ContextTrait\ParamTrait;
use Mainto\MRPC\Protocol\Request\ContextTrait\RpcMessageTrait;
use Mainto\MRPC\Protocol\Request\ContextTrait\RpcReturnTrait;
use Mainto\MRPC\Protocol\Request\ContextTrait\RpcUrlTrait;
use Mainto\MRPC\Protocol\Request\ContextTrait\SessionTrait;
use Mainto\MRPC\RpcUtil\RpcBlock;

class RpcContext {
    use ParamTrait;
    use RpcUrlTrait;
    use RpcMessageTrait;
    use RpcReturnTrait;
    use SessionTrait;
    use HeaderTrait;

    private string $requestId;
    private ?RpcBlock $rpcBlock = null;
    private $paramMap = null;
    private $rawMode = false;

    /**
     * RpcRequest constructor.
     * @param RpcInvoke $invoke
     * @param $requestId
     * @param array $params
     * @param RpcBlock $block
     * @param $rawMode
     */
    public function __construct (RpcInvoke $invoke, string $requestId, array $params, RpcBlock $block, $rawMode) {
        $this->requestInvoke = $invoke;
        $this->requestId = $requestId;
        $this->requestParams = collect($params);
        $this->rpcBlock = $block;
        $this->session_id = $this->getSessionId();
        $this->rawMode = $rawMode;
    }

    /**
     * 是否是 Raw 模式
     * @return bool
     */
    public function isRawMode (): bool {
        return $this->rawMode;
    }
}