<?php


namespace Mainto\MRPC\Server\Connection;


use Mainto\MRPC\Server\BaseRpcConnection;
use Mainto\MRPC\Server\ConnectionHandler;
use Mainto\MRPC\Util\Net\Net;

class RpcUnixConnection extends BaseRpcConnection {
    /**
     * RpcServer constructor.
     * @param $address
     * @param ConnectionHandler $handler
     */
    private function __construct ($address, ConnectionHandler $handler) {
        parent::__construct(Net::dial("unix", $address), $address, $handler);
    }

    public static function newInstance ($address, ConnectionHandler $handler) {
        return new self($address, $handler);
    }
}