<?php


namespace Mainto\MRPC\Util\IO;


use Mainto\MRPC\Util\Bytes\Bytes;
use RuntimeException;

class IOUtil {
    public static function readAll (Reader $reader): string {
        $buffer = Bytes::newBuffer();

        $buffer->readFrom($reader);

        return $buffer->bytes();
    }

    public static function readFullSize(Reader $reader, $size) {
        $buf = "";

        $allReader = 0;
        while (true) {
            $read = $reader->read($size - $allReader);

            $buf .= $read;
            $allReader += strlen($read);

            if ($allReader >= $size) {
                return $buf;
            }
        }

        throw new RuntimeException("read full err");
    }
}