<?php

namespace Mainto\MRPC\Service\Struct;


use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Support\Collection;
use RuntimeException;

class Config {
    const Prefix = "/mainto.lutty/service/";

    private Collection $paths;

    private Collection $messages;

    private Collection $crons;

    private Collection $websockets;

    /**
     * @var array ["[POST]/test/example/add" => true]
     */
    private array $_pathUrlMap;

    public function __construct () {
        $this->paths = collect([]);
        $this->messages = collect([]);
        $this->crons = collect([]);
        $this->websockets = collect([]);
    }

    public function addPath (Path $path): void {
        if ($path->getHttpUrl() && $path->getHttpMethod()) {
            $urlKey = sprintf("[%s]%s", $path->getHttpMethod(), $path->getHttpUrl());
            if (isset($this->_pathUrlMap[$urlKey])) {
                throw new RuntimeException("already has this router: {$urlKey}");
            }

            $this->_pathUrlMap[$urlKey] = true;
        }

        $this->paths->push($path);
    }

    public function addMessage (Message $message): void {
        $this->messages->push($message);
    }

    public function addWebsocket (Websocket $message): void {
        $this->websockets->push($message);
    }

    public function addCron (Cron $cron): void {
        $this->crons->push($cron);
    }

    /**
     * @return Collection
     */
    public function getPaths (): Collection {
        return $this->paths;
    }

    /**
     * @return Collection
     */
    public function getCrons (): Collection {
        return $this->crons;
    }

    /**
     * @return Collection
     */
    public function getMessages (): Collection {
        return $this->messages;
    }

    /**
     * @return Collection
     */
    public function getWebsockets (): Collection {
        return $this->websockets;
    }
}