<?php

namespace Mainto\MRPC\Server;

use Mainto\MRPC\Protocol\Request\Extend\RequestExtendHeader;
use Mainto\MRPC\Protocol\Request\Request;
use Mainto\MRPC\Server\ContextTrait\HeaderTrait;
use Mainto\MRPC\Server\ContextTrait\ParamTrait;
use Mainto\MRPC\Server\ContextTrait\RequestTrait;
use Mainto\MRPC\Server\ContextTrait\RpcMessageTrait;
use Mainto\MRPC\Server\ContextTrait\SessionTrait;

class RpcContext {
    use ParamTrait;
    use HeaderTrait;
    use SessionTrait;
    use RpcMessageTrait;
    use RequestTrait;

    public static string $currentTraceId = "";

    /**
     * @param Request $request
     * @param RpcParams $params
     */
    public function __construct (Request $request, RpcParams $params) {
        $this->rpcParams = $params;
        $this->request = $request;

        if ($request->hasExt()) {
            $ext = $request->getExt();
            if ($ext instanceof RequestExtendHeader) {
                foreach ($ext->getAllHeader() as $key => $value) {
                    $this->requestHeaders[$key] = count($value) === 1 ? $value[0] : $value;
                }
            }
        }

        self::$currentTraceId = $this->request->getTraceId();
        $this->session_id = $this->getSessionId();
    }
}