<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 18-10-22
 * Time: 下午3:17
 */

namespace Mainto\MRPC\Providers;

use Doctrine\Common\Annotations\AnnotationRegistry;
use Mainto\MRPC\Command\RpcSidecarCommand;
use Mainto\MRPC\Command\RpcServerCommand;
use Mainto\MRPC\Server\RpcRouter;

class ServiceProvider extends \Illuminate\Support\ServiceProvider {
    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot () {
        if ($this->app->runningInConsole()) {

            $this->publishes([
                __DIR__.'/../config.php' => config_path('rpc-server.php'),
            ], 'config');
        }
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register () {
        $this->mergeConfigFrom(__DIR__.'/../config.php', 'rpc-server');

        $this->app->bind('command.rpc.sidecar', RpcSidecarCommand::class);
        $this->app->bind('command.rpc.server', RpcServerCommand::class);

        $this->commands([
            'command.rpc.sidecar',
            'command.rpc.server',
        ]);

        $this->app->singleton('rpc-server', fn() => RpcRouter::getInstance());

        $loader = new RpcAnnotationLoader();
        // todo remove
        AnnotationRegistry::registerLoader([$loader, "loadClass"]);
    }
}
