<?php


namespace Mainto\MRPC\Util\IO;


use Mainto\MRPC\Util\Bytes\Bytes;
use Mainto\MRPC\Util\Reader\LimitReader;

class IO {
    public static function copy (Writer $dst, Reader $src) {
        while (true) {
            $read = $src->read(32 * 1024);
            if ($read === null) {
                break;
            }

            $dst->write($read);
        }
    }

    public static function IOWriterToBytes (WriterTo $writerTo): string {
        $buffer = Bytes::newBuffer();

        $writerTo->writeTo($buffer);

        return $buffer->bytes();
    }

    public static function limitReader(Reader $reader, int $size): Reader {
        return new LimitReader($reader, $size);
    }
}