<?php


namespace Mainto\MRPC\Server;


use Mainto\MRPC\Protocol\Request\RequestReader;
use Mainto\MRPC\Protocol\RpcConnection;
use Mainto\MRPC\Tool\Socket;

class Master extends RpcConnection {

    private static Master $instance;

    /**
     * @param string $server
     * @param string $port
     * @param string $key
     */
    protected function __construct (string $server, string $port, string $key) {
        parent::__construct($server, $port, $key);
    }

    public static function newInstance(string $server, string $port, string $key): Master {
        if (self::$instance == null) {
            self::$instance = new self($server, $port, $key);
        }

        return self::$instance;
    }

    public function onRequest (RequestReader $request) {

    }

    public function onClose (Socket $socket) {
    }
}