<?php


namespace Mainto\MRPC\Protocol;


use Exception;
use Illuminate\Support\Facades\Log;
use Mainto\MRPC\Protocol\Request\RequestReader;
use Mainto\MRPC\Tool\Socket;

abstract class RpcConnection {
    /**
     * @var string
     */
    private string $server;

    /**
     * @var string
     */
    private string $port;

    /**
     * @var string
     */
    private string $key;

    /**
     * 啰嗦模式
     * @var bool
     */
    public static $verboseMode = false;

    /**
     * RpcServer constructor.
     */
    protected function __construct (string $server, string $port, string $key) {
        self::$verboseMode = env('RPC_VERBOSE_MODE', null);

        if (self::$verboseMode === null) {
            self::$verboseMode = env('APP_DEBUG', false);
        }

        $this->server = $server;
        $this->port = $port;
        $this->key = $key;
    }

    /**
     * RpcServer destruct
     */
    public function __destruct () {
        Log::error("server exit...");
    }

    abstract public function onRequest(RequestReader $request);

    abstract public function onClose(Socket $socket);

    public function start() {
        $socket = new Socket($this->server, $this->port);
        $socket->send("todo");

        while (true) {
            try {
                $request = RequestReader::ReadRequestFrom($socket);

                $this->onRequest($request);
            } catch (Exception $exception) {
                Log::error($exception);
                break;
            }
        }

        $this->onClose($socket);

        $socket->close();
    }
}