<?php


namespace Mainto\MRPC\Protocol\Response;


use Mainto\MRPC\Protocol\Response\Extend\HeaderExtend;

class ExtendFactory {
    public static array $extendMap = [
        Extend::MagicNumUrlInvoke => HeaderExtend::class
    ];

    public static function getManagedRequestExtendByMagicNum(int $magicNum): Extend {
        if (!isset(self::$extendMap[$magicNum])) {
            throw new \RuntimeException("magic is not support");
        }

        $class = self::$extendMap[$magicNum];

        return new $class();
    }
}