<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/4/7
 * Time: 下午3:16
 */

namespace Mainto\MRPC\Protocol\Request\ContextTrait;

use Mainto\MRPC\RpcUtil\Block\MessageInvokeControlBlock;
use Mainto\MRPC\RpcUtil\RpcMessageQueue;

trait RpcMessageTrait {
    /**
     * 是否是从proxy转发来的请求
     *
     * @return bool
     */
    public function isRpcMessageHookRequest () {
        return $this->rpcBlock instanceof MessageInvokeControlBlock;
    }

    /**
     * 获得消息队列名称
     *
     * @return null|string
     */
    public function getRpcMessageHookName (): ?string {
        if ($this->rpcBlock instanceof MessageInvokeControlBlock) {
            return $this->rpcBlock->getMessageName();
        }

        return null;
    }

    /**
     * 是否是重试的Block
     *
     * @return bool|null
     */
    public function isRetry (): ?bool {
        if ($this->rpcBlock instanceof MessageInvokeControlBlock) {
            return $this->rpcBlock->getContext()['is_retry'];
        }

        return null;
    }

    /**
     * 是否是延迟的Block
     *
     * @return bool|null
     */
    public function isDelay (): ?bool {
        if ($this->rpcBlock instanceof MessageInvokeControlBlock) {
            return $this->rpcBlock->getContext()['is_delay'];
        }

        return null;
    }

    /**
     * 获得延迟时间
     *
     * @return int|null
     */
    public function getDelayTime (): ?int {
        if ($this->rpcBlock instanceof MessageInvokeControlBlock) {
            return $this->rpcBlock->getContext()['delay_time'];
        }

        return null;
    }

    /**
     * 获得消息类型（如果存在）
     *
     * @return string|null
     */
    public function getMsgType (): ?string {
        if ($this->rpcBlock instanceof MessageInvokeControlBlock) {
            return $this->rpcBlock->getContext()['msg_type'];
        }

        return null;
    }

    /**
     * 回复用户消息
     *
     * @param $msg
     * @return bool
     */
    public function replayMessage (string $msg): bool {
        if ($this->rpcBlock instanceof MessageInvokeControlBlock) {
            $roomName = $this->getRoomName();
            $userId = $this->getUserId();
            if ($roomName && $userId) {
                RpcMessageQueue::getInstance()->addMessageToWebSocket($roomName, $userId, $msg);
                return true;
            }
        }
        return false;
    }

    /**
     * 获得房间名称（如果存在）
     *
     * @return string|null
     */
    public function getRoomName (): ?string {
        if ($this->rpcBlock instanceof MessageInvokeControlBlock) {
            return $this->rpcBlock->getContext()['room_name'];
        }

        return null;
    }

    /**
     * 获得用户ID（如果存在）
     *
     * @return string|null
     */
    public function getUserId (): ?string {
        if ($this->rpcBlock instanceof MessageInvokeControlBlock) {
            return $this->rpcBlock->getContext()['user_id'];
        }

        return null;
    }

    /**
     * 回复用户消息
     *
     * @param $userId
     * @param $msg
     * @return bool
     */
    public function sendMessage (string $userId, string $msg): bool {
        if ($this->rpcBlock instanceof MessageInvokeControlBlock) {
            $roomName = $this->getRoomName();
            if ($roomName && $userId) {
                RpcMessageQueue::getInstance()->addMessageToWebSocket($roomName, $userId, $msg);
                return true;
            }
        }
        return false;
    }

    /**
     * 发送用户消息
     *
     * @param string $roomName
     * @param string $userId
     * @param string $msg
     */
    public function sendMessageToUser (string $roomName, string $userId, string $msg) {
        RpcMessageQueue::getInstance()->addMessageToWebSocket($roomName, $userId, $msg);
    }

    /**
     * 发送消息给自己
     *
     * @param string $msg
     * @return bool
     */
    public function sendMessageToSelf (string $msg): bool {
        if ($this->rpcBlock instanceof MessageInvokeControlBlock) {
            $roomName = $this->getRoomName();
            $userId = $this->getUserId();
            if ($roomName && $userId) {
                RpcMessageQueue::getInstance()->addMessageToWebSocket($roomName, $userId, $msg);
                return true;
            }
        }
        return false;
    }

    /**
     * 广播房间消息
     *
     * @param $msg
     * @return bool
     */
    public function broadcastMessage (string $msg): bool {
        if ($this->rpcBlock instanceof MessageInvokeControlBlock) {
            $roomName = $this->getRoomName();
            if ($roomName) {
                RpcMessageQueue::getInstance()->addMessageToWebSocket($roomName, "[all]", $msg);
                return true;
            }
        }
        return false;
    }

    /**
     * 广播消息到指定房间
     *
     * @param string $roomName
     * @param string $msg
     */
    public function broadcastMessageToRoom (string $roomName, string $msg) {
        RpcMessageQueue::getInstance()->addMessageToWebSocket($roomName, "[all]", $msg);
    }

    /**
     * 获得内容类型
     * @return null|string
     */
    public function getContextType (): ?string {
        if ($this->rpcBlock instanceof MessageInvokeControlBlock) {
            return $this->rpcBlock->getContext()['context_type'];
        }

        return null;
    }
}