<?php


namespace Mainto\MRPC\Protocol\Common;


class BaseType {
    const StreamSize = 3;
    const EmptySize = 3;
    const MainTypeSize = 6;
    const SecondTypeSize = 4;
    const Mask = 0xFFFF;
    const StreamMask = self::Mask & 0xE000;
    const MainTypeMask = self::Mask & 0x03F0;
    const SecondTypeMask = self::Mask & 0x000F;
    const TypeMask = self::MainTypeMask | self::SecondTypeMask;

    const StreamOpen = (1 << (BaseType::EmptySize + BaseType::MainTypeSize + BaseType::SecondTypeSize)) & BaseType::StreamMask;
    const StreamChunk = (2 << (BaseType::EmptySize + BaseType::MainTypeSize + BaseType::SecondTypeSize)) & BaseType::StreamMask;
    const StreamClose = (3 << (BaseType::EmptySize + BaseType::MainTypeSize + BaseType::SecondTypeSize)) & BaseType::StreamMask;
    const StreamErrorClose = (4 << (BaseType::EmptySize + BaseType::MainTypeSize + BaseType::SecondTypeSize)) & BaseType::StreamMask;
}