<?php


namespace Mainto\MRPC\Util\Net;


use Mainto\MRPC\Util\Net\Listener\UnixListener;
use RuntimeException;

class Net {
    public static function dial ($network, $address): Conn {
        switch ($network) {
            case "unix":
                return Dialer::dialUnix($address);
            case "tcp":
                return Dialer::dialTcp($address);
        }

        throw new RuntimeException("not support network");
    }

    public static function listen($network, $address): Listener {
        switch ($network) {
            case "unix":
                return new UnixListener($address);
        }

        throw new RuntimeException("not support network");
    }
}