<?php


namespace Mainto\MRPC\Server\ConnectionHandler;


use Mainto\MRPC\Protocol\Common\Body;
use Mainto\MRPC\Protocol\Common\Types\RequestHeaderType;
use Mainto\MRPC\Protocol\Request\Request;
use Mainto\MRPC\Protocol\Response\Response;
use Mainto\MRPC\Server\Connection\RpcUnixConnection;
use Mainto\MRPC\Server\RpcRouter;
use Mainto\MRPC\Server\BaseConnectionHandler;
use Mainto\MRPC\Util\Net\Conn;
use Mainto\MRPC\Util\OS;
use RuntimeException;

class MasterConnectionHandler extends BaseConnectionHandler {
    private static ?MasterConnectionHandler $instance = null;

    public static function newInstance (): MasterConnectionHandler {
        if (self::$instance == null) {
            OS::setProcessTitle(sprintf("rpc-php [%s] [master] master", config('rpc-server.service_name')));

            self::$instance = new self();
        }

        return self::$instance;
    }

    public function onRequest (Request $request): Response {
        switch ($request->getType()) {
            case RequestHeaderType::SidecarScaleUpType :
                $collection = $request->getBody()->toCollection();
                $unixAddress = $collection->get("unix");
                $childId = pcntl_fork();
                if ($childId < 0) {
                    throw new RuntimeException("fork fail");
                } elseif ($childId == 0) {
                    //                    $this->close();
                    OS::setProcessTitle(sprintf("rpc-php [%s] [%s] child", config('rpc-server.service_name'), $unixAddress));

                    RpcUnixConnection::newInstance($unixAddress, new ChildConnectionHandler())->start();
                    exit(0);
                }

                $this->cacheResponse->useReturnOKType();
                $this->cacheResponse->setBody(Body::newJsonBody(json_encode(["pid" => $childId])));
                return $this->cacheResponse;
            case RequestHeaderType::SidecarConfigType:
                return self::serviceConfigResponse();
            case RequestHeaderType::SystemCheckType:

                $this->cacheResponse->useReturnOKType();
                return $this->cacheResponse;
        }

        $this->cacheResponse->useReturnErrType();
        return $this->cacheResponse;
    }

    public function onClose (Conn $socket) {
    }

    public static function serviceConfigResponse () {
        $response = new Response();
        $response->useReturnOKType();

        $body = Body::newJsonBody(json_encode(RpcRouter::getInstance()->getBaseRouterConfig()));
        $response->setBody($body);

        return $response;
    }

    public function beforeStart (Conn $conn) {
        // 忽略子进程退出信号
        pcntl_signal(SIGCHLD, SIG_IGN);
    }
}