<?php


namespace Mainto\MRPC\Server\Connection;


use Mainto\MRPC\Server\BaseRpcConnection;
use Mainto\MRPC\Server\ConnectionHandler;
use Mainto\MRPC\Util\Net\Net;

class RpcTcpConnection extends BaseRpcConnection {
    /**
     * RpcServer constructor.
     * @param string $address
     * @param $streamId
     * @param ConnectionHandler $handler
     */
    private function __construct (string $address, $streamId,  ConnectionHandler $handler) {
        parent::__construct(Net::dial("tcp", $address), $streamId, $handler);
    }

    public static function newInstance(string $address, $streamId,  ConnectionHandler $handler) {
        return new self($address, $streamId, $handler);
    }
}