<?php


namespace Mainto\MRPC\Protocol\Response\Extend;


use Mainto\MRPC\Protocol\Response\Extend;
use Mainto\MRPC\Protocol\Response\HeaderExtend;
use Mainto\MRPC\Util\Binary;
use Mainto\MRPC\Util\Bytes\Bytes;
use Mainto\MRPC\Util\IO\Reader;
use Mainto\MRPC\Util\IO\Writer;
use Mainto\MRPC\Util\Reader\LittleEndianReader;

class ResponseExtendError implements HeaderExtend {
    private string $traceId = "";
    private string $errMsg = "";
    private int $errorCode = 0;

    public function magicNum () {
        return Extend::MagicNumErrorExtend;
    }

    public function writeHeaderTo (Writer $writer): int {
        $buffer = Bytes::newBuffer();

        $buffer->writeString($this->traceId);

        $buffer->writeByte(Binary::$littleEndian::intToUint64($this->errorCode));
        $buffer->writeString(Binary::$littleEndian::intToUint16(strlen($this->errMsg)));

        $buffer->writeString($this->errMsg);

        return $buffer->writeTo($writer);
    }

    public function readHeaderFrom (Reader $reader): int {
        $littleEndianReader = new LittleEndianReader($reader);

        $this->traceId = $littleEndianReader->read(16);

        $this->errorCode = $littleEndianReader->readerUint64();

        $msgLen = $littleEndianReader->readerUint16();
        $this->errMsg = $littleEndianReader->read($msgLen);

        return $littleEndianReader->getTotalReaderSize();
    }

    /**
     * @return string
     */
    public function getTraceId (): string {
        return $this->traceId;
    }

    /**
     * @param string $traceId
     */
    public function setTraceId (string $traceId): void {
        if (strlen($traceId) < 16) {
            $traceId = str_repeat("0", 16 - strlen($traceId)).$traceId;
        } else {
            $traceId = substr($traceId, 0, 16);
        }
        $this->traceId = $traceId;
    }

    /**
     * @return string
     */
    public function getErrMsg (): string {
        return $this->errMsg;
    }

    /**
     * @param string $errMsg
     */
    public function setErrMsg (string $errMsg): void {
        $this->errMsg = $errMsg;
    }

    /**
     * @return int
     */
    public function getErrorCode (): int {
        return $this->errorCode;
    }

    /**
     * @param int $errorCode
     */
    public function setErrorCode (int $errorCode): void {
        $this->errorCode = $errorCode;
    }

    public function dumpToWriter (Writer $writer) {
        $writer->write(sprintf("trace id: %s\n", $this->traceId));
        $writer->write(sprintf("error code: %X\n", $this->errorCode));
        $writer->write(sprintf("error msg: %s\n", $this->errMsg));
    }
}