<?php


namespace Mainto\MRPC\Protocol\Request\Extend;


use Mainto\MRPC\Protocol\Common\MapReadWrite;
use Mainto\MRPC\Protocol\Request\BodyExtend;
use Mainto\MRPC\Protocol\Request\Extend;
use Mainto\MRPC\Protocol\Request\HeaderExtend;
use Mainto\MRPC\Protocol\Request\QueryExtend;
use Mainto\MRPC\Util\IO\Reader;
use Mainto\MRPC\Util\IO\Writer;

class RequestExtendUrlInvoke extends RequestExtendHeader implements HeaderExtend, BodyExtend, QueryExtend {
    private array $query = [];
    private array $file = [];

    public function magicNum () {
        return Extend::MagicNumUrlInvoke;
    }

    public function checkParams () {
    }

    public function setQuery(string $key, array $values) {
        $this->checkAndSet($this->query, $key, $values);
    }

    public function addQuery(string $key, string $value) {
        $this->checkAndAdd($this->query, $key, $value);
    }

    /**
     * @return array
     */
    public function getAllQuery (): array {
        return $this->query;
    }

    /**
     * @param string $key
     * @return array
     */
    public function getQuery (string $key): array {
        return $this->query[$key];
    }

    public function addFile(string $key, Reader $reader) {
        $this->file[$key] = $reader;
    }

    public function writeBodyTo (Writer $writer): int {
        if ($this->file) {
            throw new \RuntimeException("current not support file upload");
        }

        return 0;
    }

    public function readBodyFrom (Reader $reader): int {
        // todo current not support file upload
        return 0;
    }

    public function writeQueryTo (Writer $writer): int {
        return MapReadWrite::littleWriteMapTo($this->query, $writer);
    }

    public function readQueryFrom (Reader $reader): int {
        return MapReadWrite::littleReadMapFrom($this->query, $reader);
    }

    public function dumpToWriter (Writer $writer) {
        $writer->write("-------------- query  --------------\n");
        $queryKeyMaxLen = 0;
        array_walk($this->query, function ($_, $k) use (&$queryKeyMaxLen) {
            $queryKeyMaxLen = max($queryKeyMaxLen, strlen($k));
        });

        foreach ($this->query as $key => $values) {
            if (count($values) == 1) {
                $writer->write(sprintf("%{$queryKeyMaxLen}s: %s\n", $key, $values[0]));
            } else {
                $writer->write(sprintf("%{$queryKeyMaxLen}s: [ %s ]\n", $key, implode(", ", $values)));
            }
        }

        parent::dumpToWriter($writer);
    }
}