<?php

namespace Mainto\MRPC\Command;


use Illuminate\Console\Command;
use Mainto\MRPC\Command\Sidecar\Sidecar;

class RpcSidecarCommand extends Command {
    const SidecarUrl = "https://s3.code.hzmantu.com/";

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:sidecar {option?} {arg?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Sidecar Command';

    /**
     * 可用的 Command
     * @var array
     */
    private $commands = [
        'start',
        'init',
    ];

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle () {
        $command = $this->argument('option');
        $arg = $this->argument('arg');

        if (!$command || !in_array($command, $this->commands)) {
            dd('Usage: php artisan rpc:sidecar {start|init} {worker}');
        }
        if (!$arg && $command != 'init') {
            dd('Usage: php artisan rpc:sidecar {start|init} {worker}');
        }
        $sidecar = new Sidecar(self::SidecarUrl);
        if ($iniFile = get_cfg_var('cfg_file_path')) {
            $sidecar->setPHPIniFile($iniFile);
        }

        $sidecar->initSidecar();

        switch ($command) {
            case "start":
                chdir(dirname($sidecar->getRunFile()));
                system(sprintf("%s %s", $sidecar->getRunFile(), $arg));
                break;
            case "init":
                break;
        }

        return 0;
    }
}
