<?php


namespace Mainto\MRPC\Tool\Bytes;


class Reader implements \Mainto\MRPC\Tool\IO\Reader {
    private int $offset = 0;

    private string $bytes;


    public function __construct (string $bytes) {
        $this->bytes = $bytes;
    }

    private function empty() {
        return $this->offset >= strlen($this->bytes);
    }

    public function read (int $size): ?string {
        if ($this->empty()) {
            return null;
        }

        $read = substr($this->bytes, $this->offset, $size);

        $this->offset += strlen($read);

        return $read;
    }
}