<?php
namespace Mainto\MRPC\Service\Struct;


use Illuminate\Contracts\Support\Arrayable;

class Message implements Arrayable {
    private string $messageHookName;
    /**
     * @var string
     */
    private string $class;
    /**
     * @var string
     */
    private string $method;

    /**
     * @param string $messageHookName
     */
    public function setMessageHookName (string $messageHookName): void {
        $this->messageHookName = $messageHookName;
    }

    public function isEmpty (): bool {
        return $this->messageHookName == "";
    }

    public function setClass (string $className) {
        $this->class = $className;
    }

    public function setMethod (string $methodName) {
        $this->method = $methodName;
    }

    /**
     * @return string
     */
    public function getClass (): string {
        return $this->class;
    }

    /**
     * @return string
     */
    public function getMethod (): string {
        return $this->method;
    }

    public function toArray () {
        return [
            'class'             => $this->class,
            'method'            => $this->method,
            'message_hook_name' => $this->messageHookName,
        ];
    }
}