<?php

namespace Mainto\MRPC\Service\Struct;


use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Support\Collection;
use RuntimeException;

class Config implements Arrayable {
    const Prefix = "/mainto.lutty/service/";

    private static Collection $paths;

    private static Collection $messages;

    private static Collection $crons;

    /**
     * @var array ["[POST]/test/example/add" => true]
     */
    private static array $_pathUrlMap;

    public static function addPath (Path $path): void {
        if ($path->getHttpUrl() && $path->getHttpMethod()) {
            $urlKey = sprintf("[%s]%s", $path->getHttpMethod(), $path->getHttpUrl());
            if (isset(self::$_pathUrlMap[$urlKey])) {
                throw new RuntimeException("already has this router: {$urlKey}");
            }

            self::$_pathUrlMap[$urlKey] = true;
        }

        self::getPaths()->push($path);
    }

    /**
     * @return Collection
     */
    private static function getCrons(): Collection {
        if (self::$crons == null) {
            self::$crons = collect([]);
        }

        return self::$crons;
    }

    /**
     * @return Collection
     */
    private static function getMessages(): Collection {
        if (self::$messages == null) {
            self::$messages = collect([]);
        }

        return self::$messages;
    }

    /**
     * @return Collection
     */
    private static function getPaths(): Collection {
        if (self::$paths == null) {
            self::$paths = collect([]);
        }

        return self::$paths;
    }

    public static function addMessage (Message $message): void {
        self::$messages->push($message);
    }

    public static function addCron (Cron $cron): void {
        self::$crons->push($cron);
    }

    public function toArray (): array {
        $config = [
            'name'     => config('rpc-server.service_name'),
            'paths'    => self::getPaths()->toArray(),
            'crons'    => [],
            'messages' => [],
        ];

        if (config('rpc-server.cron.enable')) {
            $config['crons'] = self::getCrons()->toArray();
        }

        if (config('rpc-server.rabbit_mq.enable')) {
            $config['messages'] = self::getMessages()->toArray();
        }

        return $config;
    }
}