<?php
/**
 * Created by PhpStorm.
 * User: jiuli
 * Date: 2018/4/7
 * Time: 下午3:20
 */

namespace Mainto\MRPC\Protocol\Request\ContextTrait;

use Mainto\MRPC\ProtocolInvoke;
use Mainto\MRPC\RpcUtil\Stream\RpcStreamProviderInterface;

trait RpcReturnTrait {
    private $isSetRetData = false;

    /**
     * @var RpcInvoke
     */
    private $requestInvoke;

    /**
     * 设置返回内容
     * @param $data
     * @return bool
     */
    public function sendReturnToRemote ($data) {
        if (!$this->isSetRetData) {
            $this->isSetRetData = true;
            $this->requestInvoke->sendReturnToRemote($this->requestId, $data);
            return true;
        }
        return false;
    }

    /**
     * 切换到流模式
     *
     * @param RpcStreamProviderInterface $provider 流模式内容提供者
     */
    public function switchToSteamMode (RpcStreamProviderInterface $provider) {
        $this->requestInvoke->startStreamMode($provider);
        //return $stream;
    }
}