<?php


namespace Mainto\MRPC\Client;


use Illuminate\Support\Facades\Log;
use Mainto\MRPC\Protocol\Request\Request;
use Mainto\MRPC\Service\Struct\Config;
use Socket\Raw\Factory;
use Socket\Raw\Socket;
use Throwable;

class Client {
    private static array $rpcConnectionMap = [];

    private Socket $socket;

    private string $serverAddress;

    /**
     * RpcClient constructor.
     *
     * @param $serverAddress
     */
    private function __construct (string $serverAddress) {
        $factory = new Factory();
        $this->socket = $factory->createTcp4();
        $this->socket->connectTimeout($serverAddress, 3);
        $this->socket->setBlocking(true);
        $this->serverAddress = $serverAddress;
    }

    public static function getInstanceByServiceName (string $serverName) {
        $client = get_etcd_client();
        $keys = $client->getKeysWithPrefix(Config::Prefix."{$serverName}/");

        if (count($keys) == 0) {
            return null;
        }
        $item = json_decode(array_random($keys), true);

        if (!isset($item['addresses']) || !isset($item['port'])) {
            return null;
        }

        foreach ($item['addresses'] as $address) {
            try {
                return self::getInstance("{$address}:{$item['port']}");
            } catch (Throwable $e) {
                Log::error("connect {$serverName}[{$address}] error: ".$e->getMessage());
            }
        }

        return null;
    }

    /**
     * 单例获取
     *
     * @param $serverAddress
     * @return Client
     */
    public static function getInstance ($serverAddress) {
        if (isset(self::$rpcConnectionMap[$serverAddress])) {
            return self::$rpcConnectionMap[$serverAddress];
        } else {
            $instance = new Client($serverAddress);
            self::$rpcConnectionMap[$serverAddress] = $instance;

            return $instance;
        }
    }

    public function Do(Request $request) {

    }
}