<?php


namespace Mainto\MRPC\Client;


use Mainto\MRPC\Protocol\Request\Request;
use Mainto\MRPC\Protocol\Response\Response;
use Mainto\MRPC\Protocol\Response\ResponseReader;
use Mainto\MRPC\Util\IO\Closer;
use Mainto\MRPC\Util\Net\Conn;

class BaseRpcClient implements Closer {
    public static string $baseUnixDir;

    protected Conn $conn;

    public function __construct (Conn $conn) {
        $this->conn = $conn;
    }

    public function Do (Request $request): Response {
        $request->writeTo($this->conn);

        $responseReader = ResponseReader::ReadResponseFrom($this->conn);

        return $responseReader->toResponse();
    }

    public function close () {
        $this->conn->close();
    }

    public static function setBaseUnixDir($dir) {
        self::$baseUnixDir = $dir;
    }
}